<?php
    use Illuminate\Support\Js;
    use Sentry\Laravel\Integration;
?>

<!DOCTYPE html>
<html
    lang="<?php echo e($bootstrapData->get('language')); ?>"
    style="<?php echo e($bootstrapData->initialTheme->getCssVariables()); ?>"
    data-theme-id="<?php echo e($bootstrapData->initialTheme['id']); ?>"
    class="<?php echo \Illuminate\Support\Arr::toCssClasses(['dark' => $bootstrapData->initialTheme['is_dark']]); ?>"
>
    <head>
        <base href="<?php echo e($htmlBaseUri); ?>" />

        <?php if(isset($seoTagsView)): ?>
            <?php echo $__env->make($seoTagsView, $pageData, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php elseif(isset($meta)): ?>
            <?php echo $__env->make('common::prerender.meta-tags', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php else: ?>
            <title><?php echo e(settings('branding.site_name')); ?></title>
        <?php endif; ?>

        <meta
            name="viewport"
            content="width=device-width, initial-scale=1, maximum-scale=5"
            data-keep="true"
        />
        <link
            rel="icon"
            type="image/x-icon"
            href="favicon/icon-144x144.png"
            data-keep="true"
        />
        <link
            rel="apple-touch-icon"
            href="favicon/icon-192x192.png"
            data-keep="true"
        />
        <link rel="manifest" href="manifest.json" data-keep="true" />
        <meta
            name="theme-color"
            content="rgb(<?php echo e($bootstrapData->initialTheme->getHtmlThemeColor()); ?>)"
            data-keep="true"
        />

        <?php if($fontFamily = $bootstrapData->initialTheme->getFontFamily()): ?>
            <?php if($bootstrapData->initialTheme->isGoogleFont()): ?>
                <link rel="preconnect" href="https://fonts.googleapis.com">
                <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
                <link href="https://fonts.googleapis.com/css2?family=<?php echo e($fontFamily); ?>:wght@400;500;600;700&display=swap" rel="stylesheet">
            <?php endif; ?>
        <?php endif; ?>

        <script>
            window.bootstrapData = <?php echo json_encode($bootstrapData->get()); ?>;
        </script>

        <?php if(isset($devCssPath)): ?>
            <link rel="stylesheet" href="<?php echo e($devCssPath); ?>" />
        <?php endif; ?>

        <?php echo app('Illuminate\Foundation\Vite')->reactRefresh(); ?>
        <?php echo app('Illuminate\Foundation\Vite')('resources/client/main.tsx'); ?>

        <?php if(file_exists($customCssPath)): ?>
            <?php if($content = file_get_contents($customCssPath)): ?>
                <style>
                    <?php echo $content; ?>

                </style>
            <?php endif; ?>
        <?php endif; ?>

        <?php if(file_exists($customHtmlPath)): ?>
            <?php if($content = file_get_contents($customHtmlPath)): ?>
                <?php echo $content; ?>

            <?php endif; ?>
        <?php endif; ?>

        <?php if($code = settings('analytics.tracking_code')): ?>
            <!-- Google tag (gtag.js) -->
            <script
                async
                src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(settings('analytics.tracking_code')); ?>"
            ></script>
            <script>
                window.dataLayer = window.dataLayer || [];
                function gtag(){dataLayer.push(arguments);}
                gtag('js', new Date());
                gtag('config', "<?php echo e(settings('analytics.tracking_code')); ?>");
            </script>
        <?php endif; ?>

        <?php echo $__env->yieldContent('head-end'); ?>
    </head>

    <body>
        <div id="root">
            <div class="flex h-screen w-screen items-center justify-center">
                <svg viewBox="0 0 32 32" fill="none" stroke-width="3" class="progress-circle indeterminate overflow-hidden w-40 h-40">
                    <circle cx="16" cy="16" r="13" role="presentation" stroke-dasharray="81.68140899333463 81.68140899333463" stroke-dashoffset="0" transform="rotate(-90 16 16)"  class="progress-circle-track"></circle>
                    <circle cx="16" cy="16" r="13" role="presentation" stroke-dasharray="81.68140899333463 81.68140899333463" stroke-dashoffset="61.26105674500097" transform="rotate(-90 16 16)"  class="progress-circle-fill"></circle>
                </svg>
            </div>
        </div>

        <?php if(! isset($ssrContent)): ?>
            <noscript>
                You need to have javascript enabled in order to use
                <strong><?php echo e(config('app.name')); ?></strong>
                .
            </noscript>
        <?php endif; ?>

        <?php echo $__env->yieldContent('body-end'); ?>
    </body>
</html>
<?php /**PATH /var/www/storage.hoogli.dev.br/common/foundation/resources/views/framework.blade.php ENDPATH**/ ?>